/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.block.entity;

import net.adventurez.entity.BlackstoneGolemEntity;
import net.adventurez.init.BlockInit;
import net.adventurez.init.ConfigInit;
import net.adventurez.init.EntityInit;
import net.adventurez.init.ItemInit;
import net.adventurez.init.SoundInit;
import net.adventurez.init.TagInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;

public class ChiseledPolishedBlackstoneHolderEntity
extends BlockEntity
implements Container {
    private NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
    private boolean startBuildingGolem = false;
    private int buildGolemCounter = 0;
    private int tickCounter = 0;

    public ChiseledPolishedBlackstoneHolderEntity(BlockPos pos, BlockState state) {
        super(BlockInit.CHISELED_POLISHED_BLACKSTONE_HOLDER_ENTITY, pos, state);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inventory.clear();
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        this.buildGolemCounter = nbt.m_128451_("buildcounter");
        this.tickCounter = nbt.m_128451_("tickcounter");
        this.startBuildingGolem = nbt.m_128471_("startbuilding");
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        nbt.m_128405_("buildcounter", this.buildGolemCounter);
        nbt.m_128405_("tickcounter", this.tickCounter);
        nbt.m_128379_("startbuilding", this.startBuildingGolem);
    }

    public static void clientTick(Level world, BlockPos pos, BlockState state, ChiseledPolishedBlackstoneHolderEntity blockEntity) {
        blockEntity.tick();
    }

    public static void serverTick(Level world, BlockPos pos, BlockState state, ChiseledPolishedBlackstoneHolderEntity blockEntity) {
        blockEntity.tick();
    }

    public boolean isValid(Level world, BlockPos pos, BlockState state) {
        int stoneCounter3 = 0;
        for (int stoneCounter = 1; stoneCounter < 10; ++stoneCounter) {
            for (int stoneCounter2 = -4; stoneCounter2 < 5; ++stoneCounter2) {
                BlockState stoneState = this.m_58904_().m_8055_(pos.m_122013_(stoneCounter).m_122030_(stoneCounter2));
                if (!stoneState.m_204336_(TagInit.PLATFORM_NETHER_BLOCKS)) continue;
                ++stoneCounter3;
            }
        }
        return stoneCounter3 == 81;
    }

    public void tick() {
        if (!this.m_7983_()) {
            if (!this.m_58904_().m_8055_(this.f_58858_.m_7494_()).m_60795_()) {
                if (!this.m_58904_().m_5776_()) {
                    Containers.m_19010_((Level)this.f_58857_, (BlockPos)this.f_58858_, this.inventory);
                    this.inventory.clear();
                }
                this.tickCounter = -1;
            } else if (ConfigInit.CONFIG.allow_blackstone_golem_summoning) {
                ++this.tickCounter;
                this.m_58904_();
                if (this.tickCounter > 40 && this.m_8020_(0).m_150930_(ItemInit.GILDED_BLACKSTONE_SHARD) && this.m_58904_().m_46472_() == Level.f_46429_) {
                    this.update();
                    this.tickCounter = 0;
                }
            }
        }
        if (this.startBuildingGolem) {
            this.buildStructure();
        }
    }

    private void update() {
        BlockState state = this.m_58900_();
        BlockPos secondHolderPos = this.m_58899_().m_122013_(10);
        BlockPos thirdHolderPos = this.m_58899_().m_122030_(5).m_122013_(5);
        BlockPos fourthHolderPos = this.m_58899_().m_122025_(5).m_122013_(5);
        BlockState north = this.m_58904_().m_8055_(this.m_58899_().m_122013_(10));
        BlockState east = this.m_58904_().m_8055_(this.m_58899_().m_122030_(5).m_122013_(5));
        BlockState west = this.m_58904_().m_8055_(this.m_58899_().m_122025_(5).m_122013_(5));
        if (north.m_60734_() == BlockInit.CHISELED_POLISHED_BLACKSTONE_HOLDER && east.m_60734_() == BlockInit.CHISELED_POLISHED_BLACKSTONE_HOLDER && west.m_60734_() == BlockInit.CHISELED_POLISHED_BLACKSTONE_HOLDER) {
            if (this.m_58904_().m_5776_()) {
                // empty if block
            }
            if (!(this.m_7983_() || ((ChiseledPolishedBlackstoneHolderEntity)BlockInit.CHISELED_POLISHED_BLACKSTONE_HOLDER_ENTITY.m_58949_((BlockGetter)this.f_58857_, secondHolderPos)).m_7983_() || ((ChiseledPolishedBlackstoneHolderEntity)BlockInit.CHISELED_POLISHED_BLACKSTONE_HOLDER_ENTITY.m_58949_((BlockGetter)this.f_58857_, thirdHolderPos)).m_7983_() || ((ChiseledPolishedBlackstoneHolderEntity)BlockInit.CHISELED_POLISHED_BLACKSTONE_HOLDER_ENTITY.m_58949_((BlockGetter)this.f_58857_, fourthHolderPos)).m_7983_() || !this.isValid(this.m_58904_(), this.m_58899_(), state))) {
                ((ChiseledPolishedBlackstoneHolderEntity)BlockInit.CHISELED_POLISHED_BLACKSTONE_HOLDER_ENTITY.m_58949_((BlockGetter)this.f_58857_, this.m_58899_().m_122013_(10))).m_6211_();
                ((ChiseledPolishedBlackstoneHolderEntity)BlockInit.CHISELED_POLISHED_BLACKSTONE_HOLDER_ENTITY.m_58949_((BlockGetter)this.f_58857_, this.m_58899_().m_122030_(5).m_122013_(5))).m_6211_();
                ((ChiseledPolishedBlackstoneHolderEntity)BlockInit.CHISELED_POLISHED_BLACKSTONE_HOLDER_ENTITY.m_58949_((BlockGetter)this.f_58857_, this.m_58899_().m_122025_(5).m_122013_(5))).m_6211_();
                this.m_6211_();
                this.m_6596_();
                this.startBuildingGolem = true;
                if (this.m_58904_().m_5776_()) {
                    for (int counting = 0; counting < 20; ++counting) {
                        double d = (double)this.m_58899_().m_123341_() + (double)this.m_58904_().m_213780_().m_188501_();
                        double e = (double)this.m_58899_().m_123342_() + (double)this.m_58904_().m_213780_().m_188501_() + 1.0;
                        double f = (double)this.m_58899_().m_123343_() + (double)this.m_58904_().m_213780_().m_188501_();
                        double d2 = (double)secondHolderPos.m_123341_() + (double)this.m_58904_().m_213780_().m_188501_();
                        double e2 = (double)secondHolderPos.m_123342_() + (double)this.m_58904_().m_213780_().m_188501_() + 1.0;
                        double f2 = (double)secondHolderPos.m_123343_() + (double)this.m_58904_().m_213780_().m_188501_();
                        double d3 = (double)thirdHolderPos.m_123341_() + (double)this.m_58904_().m_213780_().m_188501_();
                        double e3 = (double)thirdHolderPos.m_123342_() + (double)this.m_58904_().m_213780_().m_188501_() + 1.0;
                        double f3 = (double)thirdHolderPos.m_123343_() + (double)this.m_58904_().m_213780_().m_188501_();
                        double d4 = (double)fourthHolderPos.m_123341_() + (double)this.m_58904_().m_213780_().m_188501_();
                        double e4 = (double)fourthHolderPos.m_123342_() + (double)this.m_58904_().m_213780_().m_188501_() + 1.0;
                        double f4 = (double)fourthHolderPos.m_123343_() + (double)this.m_58904_().m_213780_().m_188501_();
                        this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, d, e, f, 0.0, 0.0, 0.0);
                        this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, d2, e2, f2, 0.0, 0.0, 0.0);
                        this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, d3, e3, f3, 0.0, 0.0, 0.0);
                        this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, d4, e4, f4, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
    }

    private void buildStructure() {
        ++this.buildGolemCounter;
        if (!this.m_58904_().m_5776_()) {
            int i;
            if (this.buildGolemCounter == 30) {
                this.m_58904_().m_7731_(this.m_58899_().m_7494_().m_122013_(2).m_122030_(2), Blocks.f_50731_.m_49966_(), 3);
                this.m_58904_().m_7731_(this.m_58899_().m_7494_().m_122013_(2).m_122025_(2), Blocks.f_50731_.m_49966_(), 3);
                this.m_58904_().m_7731_(this.m_58899_().m_7494_().m_122013_(3).m_122030_(2), (BlockState)((BlockState)Blocks.f_50731_.m_49966_().m_61124_((Property)StairBlock.f_56842_, (Comparable)Half.TOP)).m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.SOUTH), 3);
                this.m_58904_().m_7731_(this.m_58899_().m_7494_().m_122013_(3).m_122025_(2), (BlockState)((BlockState)Blocks.f_50731_.m_49966_().m_61124_((Property)StairBlock.f_56842_, (Comparable)Half.TOP)).m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.SOUTH), 3);
                this.m_58904_().m_7731_(this.m_58899_().m_7494_().m_122013_(7).m_122029_(), Blocks.f_50730_.m_49966_(), 3);
                this.m_58904_().m_7731_(this.m_58899_().m_7494_().m_122013_(7).m_122024_(), Blocks.f_50730_.m_49966_(), 3);
                this.m_58904_().m_5594_(null, this.m_58899_(), SoundEvents.f_12447_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (this.buildGolemCounter == 60) {
                this.m_58904_().m_7731_(this.m_58899_().m_6630_(2).m_122013_(3).m_122030_(2), Blocks.f_50731_.m_49966_(), 3);
                this.m_58904_().m_7731_(this.m_58899_().m_6630_(2).m_122013_(3).m_122025_(2), Blocks.f_50731_.m_49966_(), 3);
                this.m_58904_().m_7731_(this.m_58899_().m_6630_(2).m_122013_(4).m_122030_(2), (BlockState)((BlockState)Blocks.f_50731_.m_49966_().m_61124_((Property)StairBlock.f_56842_, (Comparable)Half.TOP)).m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.SOUTH), 3);
                this.m_58904_().m_7731_(this.m_58899_().m_6630_(2).m_122013_(4).m_122025_(2), (BlockState)((BlockState)Blocks.f_50731_.m_49966_().m_61124_((Property)StairBlock.f_56842_, (Comparable)Half.TOP)).m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.SOUTH), 3);
                this.m_58904_().m_7731_(this.m_58899_().m_6630_(2).m_122013_(6).m_122029_(), (BlockState)Blocks.f_50733_.m_49966_().m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.TOP), 3);
                this.m_58904_().m_7731_(this.m_58899_().m_6630_(2).m_122013_(6).m_122024_(), (BlockState)Blocks.f_50733_.m_49966_().m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.TOP), 3);
                this.m_58904_().m_7731_(this.m_58899_().m_6630_(2).m_122013_(7).m_122029_(), Blocks.f_50730_.m_49966_(), 3);
                this.m_58904_().m_7731_(this.m_58899_().m_6630_(2).m_122013_(7).m_122024_(), Blocks.f_50730_.m_49966_(), 3);
                this.m_58904_().m_5594_(null, this.m_58899_(), SoundEvents.f_12447_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (this.buildGolemCounter == 90) {
                this.m_58904_().m_7731_(this.m_58899_().m_6630_(3).m_122013_(4).m_122030_(2), Blocks.f_50731_.m_49966_(), 3);
                this.m_58904_().m_7731_(this.m_58899_().m_6630_(3).m_122013_(4).m_122025_(2), Blocks.f_50731_.m_49966_(), 3);
                this.m_58904_().m_7731_(this.m_58899_().m_6630_(3).m_122013_(5).m_122030_(2), Blocks.f_50730_.m_49966_(), 3);
                this.m_58904_().m_7731_(this.m_58899_().m_6630_(3).m_122013_(5).m_122025_(2), Blocks.f_50730_.m_49966_(), 3);
                this.m_58904_().m_7731_(this.m_58899_().m_6630_(3).m_122013_(6).m_122030_(2), Blocks.f_50730_.m_49966_(), 3);
                this.m_58904_().m_7731_(this.m_58899_().m_6630_(3).m_122013_(6).m_122025_(2), Blocks.f_50730_.m_49966_(), 3);
                this.m_58904_().m_7731_(this.m_58899_().m_6630_(3).m_122013_(7).m_122029_(), (BlockState)Blocks.f_50731_.m_49966_().m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.SOUTH), 3);
                this.m_58904_().m_7731_(this.m_58899_().m_6630_(3).m_122013_(7).m_122024_(), (BlockState)Blocks.f_50731_.m_49966_().m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.SOUTH), 3);
                for (i = -1; i < 2; ++i) {
                    this.m_58904_().m_7731_(this.m_58899_().m_6630_(3).m_122013_(5).m_122030_(i), Blocks.f_50730_.m_49966_(), 3);
                    this.m_58904_().m_7731_(this.m_58899_().m_6630_(3).m_122013_(6).m_122030_(i), Blocks.f_50730_.m_49966_(), 3);
                }
                this.m_58904_().m_5594_(null, this.m_58899_(), SoundEvents.f_12447_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (this.buildGolemCounter == 120) {
                this.m_58904_().m_7731_(this.m_58899_().m_6630_(4).m_122013_(5).m_122030_(2), (BlockState)Blocks.f_50731_.m_49966_().m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.WEST), 3);
                this.m_58904_().m_7731_(this.m_58899_().m_6630_(4).m_122013_(5).m_122025_(2), (BlockState)Blocks.f_50731_.m_49966_().m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.EAST), 3);
                this.m_58904_().m_7731_(this.m_58899_().m_6630_(4).m_122013_(6).m_122030_(2), (BlockState)((BlockState)Blocks.f_50731_.m_49966_().m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.WEST)).m_61124_((Property)StairBlock.f_56843_, (Comparable)StairsShape.OUTER_LEFT), 3);
                this.m_58904_().m_7731_(this.m_58899_().m_6630_(4).m_122013_(6).m_122025_(2), (BlockState)((BlockState)Blocks.f_50731_.m_49966_().m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.EAST)).m_61124_((Property)StairBlock.f_56843_, (Comparable)StairsShape.OUTER_RIGHT), 3);
                for (i = -1; i < 2; ++i) {
                    this.m_58904_().m_7731_(this.m_58899_().m_6630_(4).m_122013_(5).m_122030_(i), Blocks.f_50730_.m_49966_(), 3);
                    this.m_58904_().m_7731_(this.m_58899_().m_6630_(4).m_122013_(6).m_122030_(i), (BlockState)Blocks.f_50731_.m_49966_().m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.SOUTH), 3);
                }
                this.m_58904_().m_7731_(this.m_58899_().m_6630_(4).m_122013_(4), Blocks.f_50730_.m_49966_(), 3);
                this.m_58904_().m_7731_(this.m_58899_().m_6630_(5).m_122013_(4), Blocks.f_50733_.m_49966_(), 3);
                this.m_58904_().m_5594_(null, this.m_58899_(), SoundEvents.f_12447_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (this.buildGolemCounter >= 150) {
                for (i = 1; i < 6; ++i) {
                    for (int o = -4; o < 6; ++o) {
                        for (int u = 1; u < 10; ++u) {
                            this.m_58904_().m_46961_(this.m_58899_().m_6630_(i).m_122030_(o).m_122013_(u), false);
                        }
                    }
                }
                BlackstoneGolemEntity stoneGolemEntity = (BlackstoneGolemEntity)EntityInit.BLACKSTONE_GOLEM.m_20615_(this.f_58857_);
                BlockPos spawnPos = new BlockPos(this.m_58899_().m_123341_(), this.m_58899_().m_123342_() + 1, this.m_58899_().m_123343_() - 5);
                stoneGolemEntity.m_20035_(spawnPos, 0.0f, 0.0f);
                stoneGolemEntity.m_6518_((ServerLevelAccessor)((ServerLevel)this.m_58904_()), this.m_58904_().m_6436_(this.m_58899_()), MobSpawnType.STRUCTURE, null, null);
                stoneGolemEntity.sendtoEntity();
                this.m_58904_().m_7967_((Entity)stoneGolemEntity);
                this.m_58904_().m_5594_(null, this.m_58899_(), SoundInit.GOLEM_SPAWN_EVENT, SoundSource.HOSTILE, 1.0f, 1.0f);
            }
        } else {
            int i;
            double d = (double)this.m_58899_().m_123341_() + (double)this.m_58904_().m_213780_().m_188501_();
            double e = (double)this.m_58899_().m_123342_() + (double)this.m_58904_().m_213780_().m_188501_() + 1.0;
            double f = (double)this.m_58899_().m_123343_() + (double)this.m_58904_().m_213780_().m_188501_();
            if (this.buildGolemCounter > 0 && this.buildGolemCounter < 26) {
                this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, d + 2.0, e, f - 2.0, 0.0, 0.0, 0.0);
                this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, d - 2.0, e, f - 2.0, 0.0, 0.0, 0.0);
                this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, d + 2.0, e, f - 3.0, 0.0, 0.0, 0.0);
                this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, d - 2.0, e, f - 3.0, 0.0, 0.0, 0.0);
                this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, d + 1.0, e, f - 7.0, 0.0, 0.0, 0.0);
                this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, d - 1.0, e, f - 7.0, 0.0, 0.0, 0.0);
            }
            if (this.buildGolemCounter > 30 && this.buildGolemCounter < 56) {
                this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, d + 2.0, e + 1.0, f - 3.0, 0.0, 0.0, 0.0);
                this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, d - 2.0, e + 1.0, f - 3.0, 0.0, 0.0, 0.0);
                this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, d + 2.0, e + 1.0, f - 4.0, 0.0, 0.0, 0.0);
                this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, d - 2.0, e + 1.0, f - 4.0, 0.0, 0.0, 0.0);
                this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, d + 1.0, e + 1.0, f - 6.0, 0.0, 0.0, 0.0);
                this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, d - 1.0, e + 1.0, f - 6.0, 0.0, 0.0, 0.0);
                this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, d + 1.0, e + 1.0, f - 7.0, 0.0, 0.0, 0.0);
                this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, d - 1.0, e + 1.0, f - 7.0, 0.0, 0.0, 0.0);
            }
            if (this.buildGolemCounter > 60 && this.buildGolemCounter < 86) {
                this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, d + 2.0, e + 2.0, f - 4.0, 0.0, 0.0, 0.0);
                this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, d - 2.0, e + 2.0, f - 4.0, 0.0, 0.0, 0.0);
                this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, d + 2.0, e + 2.0, f - 5.0, 0.0, 0.0, 0.0);
                this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, d - 2.0, e + 2.0, f - 5.0, 0.0, 0.0, 0.0);
                this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, d + 2.0, e + 2.0, f - 6.0, 0.0, 0.0, 0.0);
                this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, d - 2.0, e + 2.0, f - 6.0, 0.0, 0.0, 0.0);
                this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, d + 1.0, e + 2.0, f - 7.0, 0.0, 0.0, 0.0);
                this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, d - 1.0, e + 2.0, f - 7.0, 0.0, 0.0, 0.0);
                for (i = -1; i < 2; ++i) {
                    this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, d - (double)i, e + 2.0, f - 5.0, 0.0, 0.0, 0.0);
                    this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, d - (double)i, e + 2.0, f - 6.0, 0.0, 0.0, 0.0);
                }
            }
            if (this.buildGolemCounter > 90 && this.buildGolemCounter < 116) {
                this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, d + 2.0, e + 3.0, f - 5.0, 0.0, 0.0, 0.0);
                this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, d - 2.0, e + 3.0, f - 5.0, 0.0, 0.0, 0.0);
                this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, d + 2.0, e + 3.0, f - 6.0, 0.0, 0.0, 0.0);
                this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, d - 2.0, e + 3.0, f - 6.0, 0.0, 0.0, 0.0);
                this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, d, e + 3.0, f - 4.0, 0.0, 0.0, 0.0);
                this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, d, e + 4.0, f - 4.0, 0.0, 0.0, 0.0);
                for (i = -1; i < 2; ++i) {
                    this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, d - (double)i, e + 3.0, f - 5.0, 0.0, 0.0, 0.0);
                    this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, d - (double)i, e + 3.0, f - 6.0, 0.0, 0.0, 0.0);
                }
            }
        }
        if (this.buildGolemCounter >= 150) {
            this.startBuildingGolem = false;
            this.buildGolemCounter = 0;
        }
    }

    public void m_6596_() {
        super.m_6596_();
        this.sendUpdate();
    }

    private void sendUpdate() {
        if (this.m_58904_() != null) {
            BlockState state = this.m_58904_().m_8055_(this.f_58858_);
            this.m_58904_().m_7260_(this.f_58858_, state, state, 3);
        }
    }

    public void m_6211_() {
        this.inventory.clear();
        this.m_6596_();
    }

    public int m_6643_() {
        return 1;
    }

    public boolean m_7983_() {
        return this.m_8020_(0).m_41619_();
    }

    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.inventory.get(0);
    }

    public ItemStack m_7407_(int slot, int amount) {
        ItemStack result = ContainerHelper.m_18969_(this.inventory, (int)slot, (int)1);
        this.m_6596_();
        return result;
    }

    public ItemStack m_8016_(int slot) {
        this.m_6596_();
        return ContainerHelper.m_18966_(this.inventory, (int)slot);
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.inventory.set(0, (Object)stack);
        this.m_6596_();
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public ClientboundBlockEntityDataPacket toUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }
}

